local M = {}

function M.fes_version()
	local fes_mod = package.loaded.fes
	if fes_mod and fes_mod.config and fes_mod.config.fes and fes_mod.config.fes.version then
		return fes_mod.config.fes.version
	end
	return ""
end

function M.site_version()
	local fes_mod = package.loaded.fes
	if fes_mod and fes_mod.config and fes_mod.config.site and fes_mod.config.site.version then
		return fes_mod.config.site.version
	end
	return ""
end

function M.a(link, str)
	link = link or "https://example.com"
	str = str or link
	return '<a href="' .. link .. '">' .. str .. "</a>"
end

function M.ha(link, str)
	link = link or "https://example.com"
	str = str or link
	return '<a class="hidden" href="' .. link .. '">' .. str .. "</a>"
end

function M.external(link, str)
	return '<a target="_blank" href="' .. link .. '">' .. str .. "</a>"
end

function M.note(str)
	return '<div class="note">' .. str .. "</div>"
end

function M.muted(str)
	return '<div class="muted">' .. str .. "</div>"
end

function M.callout(str)
	return '<div class="callout">' .. str .. "</div>"
end

function M.h1(str)
	return "<h1>" .. (str or "") .. "</h1>"
end

function M.h2(str)
	return "<h2>" .. (str or "") .. "</h2>"
end

function M.h3(str)
	return "<h3>" .. (str or "") .. "</h3>"
end
function M.h4(str)
	return "<h4>" .. (str or "") .. "</h4>"
end

function M.h5(str)
	return "<h5>" .. (str or "") .. "</h5>"
end

function M.h6(str)
	return "<h6>" .. (str or "") .. "</h6>"
end

function M.p(str)
	return "<p>" .. (str or "") .. "</p>"
end

function M.pre(str)
	return "<pre>" .. (str or "") .. "</pre>"
end

function M.code(str)
	return "<pre><code>" .. (str or "") .. "</code></pre>"
end

function M.ul(items)
	items = items or {}
	local html = "<ul>"
	for _, item in ipairs(items) do
		html = html .. "<li>" .. tostring(item) .. "</li>"
	end
	html = html .. "</ul>"
	return html
end

function M.ol(items)
	items = items or {}
	local html = "<ol>"
	for _, item in ipairs(items) do
		html = html .. "<li>" .. tostring(item) .. "</li>"
	end
	html = html .. "</ol>"
	return html
end

function M.tl(items)
	items = items or {}
	local html = '<ul class="tl">'
	for _, item in ipairs(items) do
		html = html .. "<li>" .. tostring(item) .. "</li>"
	end
	html = html .. "</ul>"
	return html
end

function M.blockquote(str)
	return "<blockquote>" .. (str or "") .. "</blockquote>"
end

function M.hr()
	return "<hr>"
end

function M.img(src, alt)
	src = src or ""
	alt = alt or ""
	return '<img src="' .. src .. '" alt="' .. alt .. '">'
end

function M.strong(str)
	return "<strong>" .. (str or "") .. "</strong>"
end

function M.em(str)
	return "<em>" .. (str or "") .. "</em>"
end

function M.br()
	return "<br>"
end

function M.div(content, class)
	content = content or ""
	class = class or ""
	local class_attr = class ~= "" and (' class="' .. class .. '"') or ""
	return "<div" .. class_attr .. ">" .. content .. "</div>"
end

function M.span(content, class)
	content = content or ""
	class = class or ""
	local class_attr = class ~= "" and (' class="' .. class .. '"') or ""
	return "<span" .. class_attr .. ">" .. content .. "</span>"
end

-- HTML escaping utility
function M.escape(str)
	str = tostring(str or "")
	str = str:gsub("&", "&amp;")
	str = str:gsub("<", "&lt;")
	str = str:gsub(">", "&gt;")
	str = str:gsub('"', "&quot;")
	str = str:gsub("'", "&#39;")
	return str
end

-- Get site name from config
function M.site_name()
	local fes_mod = package.loaded.fes
	if fes_mod and fes_mod.config and fes_mod.config.site and fes_mod.config.site.name then
		return fes_mod.config.site.name
	end
	return ""
end

-- Get site title from config
function M.site_title()
	local fes_mod = package.loaded.fes
	if fes_mod and fes_mod.config and fes_mod.config.site and fes_mod.config.site.title then
		return fes_mod.config.site.title
	end
	return ""
end

-- Get site authors from config
function M.site_authors()
	local fes_mod = package.loaded.fes
	if fes_mod and fes_mod.config and fes_mod.config.site and fes_mod.config.site.authors then
		return fes_mod.config.site.authors
	end
	return {}
end

function M.highlight(str)
	return '<span class="highlight">' .. (str or "") .. "</span>"
end

function M.banner(str)
	return '<div class="banner">' .. (str or "") .. "</div>"
end

function M.center(str)
	return '<div class="center">' .. (str or "") .. "</div>"
end

function M.nav(link, str)
	link = link or "example.com"
	str = str or link
	return '<a class="nav" href="' .. link .. '">' .. str .. "</a>"
end

function M.rl(r, l)
	r = r or ""
	l = l or ""
	return string.format('<span class="left">%s</span><span class="right">%s</span>', r, l)
end

return M
