package doc

import (
	"fes/modules/config"
	"fmt"
	"os"
	"path/filepath"

	"github.com/pkg/browser"
)

/* open documentation in browser */
func Open() error {
	fmt.Println("Opening documentation in browser")

	tmpFile := filepath.Join(os.TempDir(), "doc.html")

	if err := os.WriteFile(tmpFile, []byte(config.Doc), 0644); err != nil {
		return err
	}

	return browser.OpenFile(tmpFile)
}
